<?php

/**
 * @package         EngageBox
 * @version         7.0.2 Pro
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2025 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

JLoader::registerNamespace('Tassos\\EngageBox', JPATH_ADMINISTRATOR . '/components/com_rstbox/EngageBox', false, false, 'psr4');

spl_autoload_register(function ($class)
{
    // Handle legacy EngageBox\* class references for backward compatibility
    if (strpos($class, 'EngageBox\\') === 0)
	{
        // Convert EngageBox\ClassName to Tassos\EngageBox\ClassName
        $newClass = 'Tassos\\EngageBox\\' . substr($class, strlen('EngageBox\\'));

        // If the new class exists, create an alias for the old class name
        if (class_exists($newClass))
		{
            class_alias($newClass, $class);
        }
    }
});